/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.container.factory;

import com.refinedmods.refinedstorage.apiimpl.network.node.CrafterManagerNetworkNode;
import com.refinedmods.refinedstorage.blockentity.CrafterManagerBlockEntity;
import com.refinedmods.refinedstorage.container.CrafterManagerContainerMenu;
import com.refinedmods.refinedstorage.screen.EmptyScreenInfoProvider;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandlerModifiable;

public class CrafterManagerMenuProvider
implements MenuProvider {
    private final CrafterManagerBlockEntity blockEntity;

    public CrafterManagerMenuProvider(CrafterManagerBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    public static void writeToBuffer(FriendlyByteBuf buf, Level level, BlockPos pos) {
        buf.m_130064_(pos);
        Map<Component, List<IItemHandlerModifiable>> containerData = ((CrafterManagerNetworkNode)((CrafterManagerBlockEntity)level.m_7702_(pos)).getNode()).getNetwork().getCraftingManager().getNamedContainers();
        buf.writeInt(containerData.size());
        for (Map.Entry<Component, List<IItemHandlerModifiable>> entry : containerData.entrySet()) {
            buf.m_130083_(entry.getKey());
            int slots = 0;
            for (IItemHandlerModifiable handler : entry.getValue()) {
                slots += handler.getSlots();
            }
            buf.writeInt(slots);
        }
    }

    public Component m_5446_() {
        return new TranslatableComponent("gui.refinedstorage.crafter_manager");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player playerEntity) {
        CrafterManagerContainerMenu container = new CrafterManagerContainerMenu(this.blockEntity, playerEntity, windowId);
        container.setScreenInfoProvider(new EmptyScreenInfoProvider());
        container.initSlotsServer();
        return container;
    }
}

